#include "RobotMotorControlCommand.h"
#include "../PhysicsEngine/IPhysicalWheelJoint.h"
#include "../DataTypes/DataString.h"

using namespace PhysicsEngine;
using namespace Configuration;
namespace SimulationEngine
{

RobotMotorControlCommand::RobotMotorControlCommand(SimRobot *entity):ICommand(ConfigurationServer::GetInstance()->GetCommandRobotControlKey())
{
	this->robot = entity;
}

RobotMotorControlCommand::~RobotMotorControlCommand()
{
}

list<DataParameter*> RobotMotorControlCommand::execute(list <DataParameter *> pars)
{
	std::list<DataParameter *>::iterator iter;
	map<int, IPhysicalJoint *>::iterator iteraux;	
	iter = pars.begin();
	while (iter!=pars.end())
	{
		DataWheelJointVelocity *vel = (DataWheelJointVelocity *)(*iter);
		IPhysicalWheelJoint *joint = 0;
		map<int, IPhysicalJoint *> motors =this->robot->GetMotors(); 
		iteraux = motors.find(vel->GetJointId());
		if (iteraux!=motors.end())
		{
			joint = (IPhysicalWheelJoint *)(iteraux->second);
			joint->ApplyJointVelocity(vel->GetVelocity());
			
		}
		
		iter++;
	}
	list<DataParameter *> ret;
	ret.push_back(new DataString("Successfully applied velocities"));
	
	return ret;
}


}
